package com.example.sefinsa_app.ui.rmd.Crear;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.util.Base64;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;

import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.RecyclerView;

import com.example.sefinsa_app.R;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;

public class MostrarImagenesRMDAdapter extends RecyclerView.Adapter<MostrarImagenesRMDAdapter.ViewHolder> {

    ArrayList<Bitmap> imagenes;
    private Context context;
    private FragmentActivity activity;
    private final CrearRMDFragment fragment;

    public MostrarImagenesRMDAdapter(CrearRMDFragment fragment, FragmentActivity activity, Context context, ArrayList<Bitmap> imagenes) {
        this.fragment = fragment;
        this.activity = activity;
        this.context = context;
        this.imagenes = imagenes;
    }

    public static class ViewHolder extends RecyclerView.ViewHolder {
        private ImageView imgVwImagen;
        private Button btnEliminar;

        public ViewHolder(@NonNull View view) {
            super(view);

            imgVwImagen = view.findViewById(R.id.imgVwArticulo);
            btnEliminar = view.findViewById(R.id.btnEliminar);
        }
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.imagenes_rmd_item, parent, false);
        return new ViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, @SuppressLint("RecyclerView") int position) {
        Bitmap imagen = imagenes.get(position);
        holder.imgVwImagen.setImageBitmap(imagen);

        holder.btnEliminar.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                imagenes.remove(position);
                fragment.eliminarImagen(imagenes.size());
                notifyItemRemoved(position);
                notifyItemRangeChanged(position, imagenes.size());
            }
        });
    }

    @Override
    public int getItemCount() { return imagenes.size(); }
}
